using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;
using DynaPDF;

namespace renderpage
{
   public partial class Form1 : Form
   {
      public Form1()
      {
         InitializeComponent();
      }

      int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         MessageBox.Show(System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0;
      }

      private CPDF m_PDF;

      private void Form1_Paint(object sender, PaintEventArgs e)
      {
         if (m_PDF == null) return;
         // Get the page object
         IntPtr pagePtr = m_PDF.GetPageObject(1);

         int w = pictureBox1.Width;  // The picture box was placed on the form.
         int h = pictureBox1.Height;

         // Calculate the image size
         m_PDF.CalcPagePixelSize(pagePtr, TPDFPageScale.psFitBest, 1.0f, w, h, TRasterFlags.rfDefault, ref w, ref h);

         // Create a bitmap in this size
         Bitmap bmp = new Bitmap(w, h, System.Drawing.Imaging.PixelFormat.Format32bppArgb);
         System.Drawing.Imaging.BitmapData bd = bmp.LockBits(new Rectangle(0, 0, w, h), System.Drawing.Imaging.ImageLockMode.WriteOnly, System.Drawing.Imaging.PixelFormat.Format32bppRgb);

         // Create a rasterizer for the bitmap
         IntPtr ras = m_PDF.CreateRasterizer(IntPtr.Zero, bd.Scan0, w, h, bd.Stride, DynaPDF.TPDFPixFormat.pxfBGRA);

         TPDFRasterImage img = new DynaPDF.TPDFRasterImage();
         img.StructSize    = System.Runtime.InteropServices.Marshal.SizeOf(img);
         img.InitWhite     = 1;
         img.DefScale      = TPDFPageScale.psFitBest;
         img.Flags         = TRasterFlags.rfInitBlack | TRasterFlags.rfCompositeWhite; // A 32 bit image has a transparent background. The flag rfCompositeWhite makes sure that the image gets pre-blended with a white background.
         img.Matrix.a      = 1.0; // Identity matrix
         img.Matrix.d      = 1.0; // Identity matrix

         // Render the page
         m_PDF.RenderPage(pagePtr, ras, ref img);

         bmp.UnlockBits(bd);
         pictureBox1.Image = bmp;
         pictureBox1.SizeMode = PictureBoxSizeMode.CenterImage;

         m_PDF.DeleteRasterizer(ref ras);
      }

      private void Form1_Load(object sender, EventArgs e)
      {
         m_PDF = new CPDF();
         m_PDF.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));
         // Initialize color management (optional but recommended). The default device profile is sRGB if no profile is set.
         TPDFColorProfiles p = new TPDFColorProfiles();
         p.StructSize = Marshal.SizeOf(p);
         p.DefInCMYKW = System.IO.Path.GetFullPath("../../../../../../test_files/ISOcoated_v2_bas.ICC");
         m_PDF.InitColorManagement(p, TPDFColorSpace.csDeviceRGB, TPDFInitCMFlags.icmBPCompensation | TPDFInitCMFlags.icmCheckBlackPoint);

         // We don't create a PDF file in this example
         m_PDF.CreateNewPDF(null);

         m_PDF.SetPageCoords(TPageCoord.pcTopDown);
         m_PDF.Append();
            m_PDF.SetFont("Arial", TFStyle.fsRegular, 20.0, false, TCodepage.cpUnicode);
            m_PDF.WriteFTextEx(50.0, 50.0, 495.0, -1.0, TTextAlign.taCenter, "A small example that shows how to render into a Bitmap.");
         m_PDF.EndPage();
      }

      private void Form1_FormClosed(object sender, FormClosedEventArgs e)
      {
         m_PDF = null;
      }
   }
}